package chess4j.eval;


import chess4j.Color;
import chess4j.board.Board;
import chess4j.board.Square;
import chess4j.pieces.Bishop;
import chess4j.pieces.Knight;
import chess4j.pieces.Pawn;
import chess4j.pieces.Piece;
import chess4j.pieces.Queen;
import chess4j.pieces.Rook;



public class EvalImpl implements Evaluator {

	private static final int QUEEN_VAL  = 900;
	private static final int ROOK_VAL   = 500;
	private static final int KNIGHT_VAL = 300;
	private static final int BISHOP_VAL = 320;
	private static final int PAWN_VAL   = 100;
	

	// A8 ... H8
	//    ...
	// A1 ... H1
	private static final int[] knightPST = {
		-5, -5, -5, -5, -5, -5, -5, -5,
		-5,  0, 10, 10, 10, 10,  0, -5,
		-5,  0, 15, 20, 20, 15,  0, -5,
		-5,  5, 10, 15, 15, 10,  5, -5,
		-5,  5, 10, 15, 15, 10,  5, -5,
		-5,  0,  8,  0,  0,  8,  0, -5,
		-5,  0,  0,  5,  5,  0,  0, -5,
		-10,-10, -5, -5, -5, -5,-10,-10 };
	
	private static final int[] pawnPST = {
		 0,  0,  0,  0,  0,  0,  0,  0,
		30, 30, 30, 30, 30, 30, 30, 30,
		14, 14, 14, 18, 18, 14, 14, 14,
		 7,  7,  7, 10, 10,  7,  7,  7,
		 5,  5,  5,  7,  7,  5,  5,  5,
		 3,  3,  3,  5,  5,  3,  3,  3,
		 0,  0,  0, -3, -3,  0,  0,  0,
		 0,  0,  0,  0,  0,  0,  0,  0 };
	
	private EvalImpl() { }
	
	public int eval(Board board) {
		
		int score=0;
		for (Square sq : Square.allSquares()) {
			Piece p = board.getPiece(sq);
			int pst;
			if (p instanceof Pawn) {
				score += p.isWhite()?PAWN_VAL : -PAWN_VAL;
				pst=pawnPST[sq.value()];
				score += p.isWhite()?pst:-pst;
			} else if (p instanceof Rook) {
				score += p.isWhite()?ROOK_VAL : - ROOK_VAL;
			} else if (p instanceof Knight) {
				score += p.isWhite()?KNIGHT_VAL : -KNIGHT_VAL;
				pst=knightPST[sq.value()];
				score += p.isWhite()?pst:-pst;
			} else if (p instanceof Bishop) {
				score += p.isWhite()?BISHOP_VAL : -BISHOP_VAL;
			} else if (p instanceof Queen) {
				score += p.isWhite()?QUEEN_VAL : -QUEEN_VAL;
			}
		}
		return board.getPlayerToMove().equals(Color.WHITE)?score:-score;
	}

}
